require( "scripts/style.lua" );


MPWelcomeFont = {
  standardFont,
  36,
  BorderColor
};

MPWelcome2Font = {
  standardFont,
  22,
  BorderColor
};

TipFont = {
  standardFont,
  18,
  BorderColor
};

MPCustomizeFont = {
  standardFont,
  18,
  BorderColor
};

MPEntryButtonGraphics = {'multi/mp_button_a', 'multi/mp_button_b','multi/mp_button_c'};

MPEntryButtonStyle =
{
	parent=DefaultStyle,
	font=StandardButtonFont,
	graphics=MPEntryButtonGraphics,
	type = kPush,
	yoffset = 1,
	xoffset = 0,
	th = kMax - 3
};



SetRandomMyDiner();

MakeDialog
{


	
	Bitmap
	{
		name="backgroundimage",
		image="multi/mp_bg",
		x=0,
		y=0,
		fit = false,
		
		MovingWindow
		{
			name="mpwelcometray",
			x=94,y=0,
			dirX = 0,
			dirY = -4,
			startoff = 1,
			onDelay = 0,
			Bitmap
			{
				image = "multi/mp_welcome_tray",
				x = 0,
				y = 0,
			
				Text
				{
					x = kCenter,
					y = 6,
					w = kMax,
					h = 100,
					flags = kHAlignCenter + kVAlignTop,
					font = MPWelcomeFont,
					label = 'mpwelcome'
				};
				
				Text
				{
					x = kCenter,
					y = 55,
					w = kMax,
					h = 100,
					flags = kHAlignCenter + kVAlignTop,
					font = MPWelcome2Font,
					label = 'mpwelcome2'
				};
			}
		};
		
		FadingWindow
		{
			x = 0,
			y = 39,
			name = "leftbubblepopup",
			lengthon = 500,
			lengthoff = 500,
			startoff = 1,
			
			Bitmap
			{
				x = 0,
				y = 0,
				image = "multi/mp_text_bubble",
				
				
				Text
				{
					x=23,y=22,
					w=261,h=91,
					flags = kHAlignCenter + kVAlignCenter,
					font=TipFont,
					name="leftbubblepopup_text",
					label=''
				};
			};
		};
		
		FadingWindow
		{
			x = 349,
			y = 281,
			name = "rightbubblepopup",
			lengthon = 500,
			lengthoff = 500,
			startoff = 1,
			
			Bitmap
			{
				x = 0,
				y = 0,
				image = "multi/mp_text_bubble",
				vflip = true;
				
				
				Text
				{
					x=46,y=61,
					w=218,h=80,
					flags = kHAlignCenter + kVAlignCenter,
					font=TipFont,
					name="rightbubblepopup_text",
					label=''
				};
			};
		};
		
		
		MovingWindow
		{
			name="mpentrytray",
			x=0,y=-117,
			dirX = 0,
			dirY = 4,
			startoff = 1,
			onDelay = 0,
			
			Bitmap
			{
				x=0,
				y=0,
				image = "multi/mp_tray",
		
				SetStyle(MPPlayButtonStyle);
				Button
				{
					x=321,
					y=16,
					label='play',
					font = {standardFont, 29, BlackColor};
					command=
						function()
							if (LoginSystemEnabled()) then
								ForceMyWaiterCreation(true);
								tutorialPlayed = false;
								if (ShowMPTutorial()) then
									result = DisplayDialog { 
										"scripts/yesno.lua", 
										body ="playmptutorial",
										title = "" 
									};
									if (result == 'no') then
										HideMPTutorial(true);
									else
										SetMultiplayerLevelTestMode(true);
										tutorialPlayed = true;
										SetMultiplayer("single");
										CreateMPTutorial();
										PreloadCustomers();
										PopModal('scripts/mpentry.lua');
										DoModal('scripts/game.lua');
										
									end
								end
								if (tutorialPlayed == false) then
									SetFade(1);
									SetMultiplayer("multi");
									SetMultiplayerLevelTestMode(false);
									LaunchMultiplayer("");
								end
							else
								DisplayDialog{
									'scripts/ok.lua', 
									body ='login_mpnotenabled',
									title = ''
								};
							end
						end
				},	
				
				SetStyle(MPEntryButtonStyle);
				
				Button
				{
					x=159,
					y=77,
					label='mpplaytutorial',
					command=
						function()
							HideMPTutorial(true);
							SetMultiplayerLevelTestMode(true);
							SetMultiplayer("single");
							CreateMPTutorial();
							PreloadCustomers();
							PopModal('scripts/mpentry.lua');
							DoModal('scripts/game.lua');
						end
				},
				
				
				
				Button
				{
					x=281,
					y=77,
					label='mppractice',
					command=
						function()
							SetMultiplayerLevelTestMode(true);
							tutorialPlayed = false;
							if (ShowMPTutorial()) then
								result = DisplayDialog { 
									"scripts/yesno.lua", 
									body ="playmptutorialpractice",
									title = "" 
								};
								if (result == 'no') then
									HideMPTutorial(true);
								else
									tutorialPlayed = true;
									SetMultiplayer("single");
									CreateMPTutorial();
									PreloadCustomers();
									PopModal('scripts/mpentry.lua');
									DoModal('scripts/game.lua');
								end
							end
							if (tutorialPlayed == false) then
								SetMultiplayer("single");
								returnresult = DoModal('scripts/multiplayer/choosegamerestaurant.lua');
								if (not (returnresult == 'cancel')) then
									CreateMPGame(returnresult);
									PreloadCustomers();
									PopModal('scripts/mpentry.lua');
									DoModal('scripts/game.lua');
								else
									SetMultiplayer("multi");
								end
							end
						end
				},
				
				
				Button
				{
					x=400,
					y=77,
					label='help',
					hflip = true,
					command=
						function()
							DoModal("scripts/multiplayer/help1.lua");
						end
				},
				
				
				
				Button
				{
					x=522,
					y=77,
					label='mpback',
					hflip = true,
					command=
						function()
							SetRestartScreen(GetMainMenuScript());
							SetMultiplayer("single");
							PopModal("scripts/mpentry.lua");
							EnterMultiplayerMusic(false);
						end
				},
				
				
				
				

						
			},
		},
		
		SetStyle(DefaultStyle);
		
		MovingWindow
		{
			name="mpavatartray",
			x=0,y=381,
			dirX = -4,
			dirY = 0,
			startoff = 1,
			onDelay = 500,
			
			Bitmap
			{
				x=0,
				y=0,
				image = "multi/mp_avatar_tray",
				Text
				{
					font = MPCustomizeFont,
					x = 30,
					y = 20,
					w = kMax,
					h = 25,
					label = 'mpchangewaiter'
				};
				FloWindow
				{
					x = 75,
					y = 110,
					frame = 2
				};
				
				SetStyle(MPEntryButtonStyle);
				Button
				{
					x=2,
					y=-50,
					label='modifyit',
					rolloverwindow="leftbubblepopup",
					rollovertext="mpwaiterinfo",
					command=
						function()
							MetricEvent(eMyWaiterMPVisits);
							SetMultiplayer("multi");
							DoModal("scripts/floscloset.lua");
						end
				},

			}
		};
		
		MovingWindow
		{
			name="mpdinertray",
			x=-178,y=381,
			dirX = 4,
			dirY = 0,
			startoff = 1,
			onDelay = 500,
			
			Bitmap
			{
				x=0,
				y=0,
				image = "multi/mp_diner_tray",
				
				Text
				{
					font = MPCustomizeFont,
					x = 65,
					y = 20,
					w = 195,
					h = 25,
					label = 'mpchangediner'
				};
				
				MyDinerWindow
				{
					x = 65,
					y = 65,
					w = 100,
					h = 75
				};
				
				SetStyle(MPEntryButtonStyle);
				Button
				{
					x=58,
					y=-50,
					label='modifyit',
					rolloverwindow="rightbubblepopup",
					rollovertext="mpdinerinfo",
					hflip = true,
					command=
						function()
							MetricEvent(eMyDinerMPVisits);
							SelectMyDiner();
						end
				},
			}
		};
	};
	
	DelayedPopup
	{
		condition = 'firstmpentry',
		dialog = 'scripts/mpentrytip.lua'
	};
	
	ScreenFade
	{
		x=0,
		y=0,
		w=800,
		h=600,
		name="screenfade"
	},
	
}


EnterMultiplayerMusic(true);
SlideMovingWindow('mpentrytray', true);
SlideMovingWindow('mpavatartray', true);
SlideMovingWindow('mpdinertray', true);
SlideMovingWindow('mpwelcometray', true);
if (LoginSystemEnabled() and (InMultiplayer() == true or GetGlobalStrSetting('mplaunchhint', '') ~= '')) then
	SetFade(1);
	LaunchMultiplayer(GetGlobalStrSetting('mplaunchhint', ''));
	SetGlobalStrSetting('mplaunchhint','');
else
	SetFade(0);
end
SetRestartScreen("scripts/mpentry.lua");